# Quick Setup Guide

## 1️⃣ Get Your Bot Token
- Open Telegram → Search [@BotFather](https://t.me/botfather)
- Send `/newbot` and follow instructions
- Copy the token (e.g., `123456:ABC-DEF...`)

## 2️⃣ Get Your User ID
- Search [@userinfobot](https://t.me/userinfobot) on Telegram
- It will show your user ID number (e.g., `123456789`)

## 3️⃣ Configure
Edit `config/config.php`:

```php
define('TELEGRAM_TOKEN', 'PASTE_YOUR_TOKEN_HERE');
define('OWNER_ID', PASTE_YOUR_USER_ID_HERE);
```

## 4️⃣ Test Locally (Optional)

### Windows
```bash
php -S localhost:8000 server.php
```

Then open: `http://localhost:8000`

### Mac/Linux
```bash
php -S 127.0.0.1:8000 server.php
```

## 5️⃣ Deploy to Server

Upload all files to your hosting:
- Use FTP/SFTP
- Or GitHub Actions
- Or any deployment method

Make sure `data/` folder is writable!

## 6️⃣ Set Webhook

Once deployed, run this command in terminal (replace with your details):

```bash
curl -X POST "https://api.telegram.org/botYOUR_TOKEN/setWebhook?url=https://yourdomain.com/webhook.php"
```

**Example:**
```bash
curl -X POST "https://api.telegram.org/bot123456:ABC-DEF1234/setWebhook?url=https://mybot.example.com/webhook.php"
```

## 7️⃣ Add Bot to Your Group

1. Open your group chat
2. Add the bot to the group
3. Make it an admin (optional, but recommended)
4. Start using commands!

## 🎯 Quick Commands

Add a friend as "chick":
- Reply to their message
- Type `/addchick`

Create and use a group:
- Reply to someone and type `/add coworkers`
- In group chat, type `coworkers` to mention them

Get help:
- Type `/help` in any chat with the bot

---

**That's it! Your bot is ready! 🎉**
