<?php
/**
 * Main Webhook Handler
 * Set this file as your Telegram bot webhook
 */

// Include configuration and classes
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/Storage.php';
require_once __DIR__ . '/src/TelegramBot.php';
require_once __DIR__ . '/src/CommandHandler.php';
require_once __DIR__ . '/src/NotificationHandler.php';

// Initialize bot
$bot = new TelegramBot(TELEGRAM_TOKEN);

// Get update
$update = $bot->getUpdate();

if (!$update || !isset($update['message'])) {
    http_response_code(400);
    exit('Invalid update');
}

// Log for debugging (optional)
// $bot->logUpdate();

// Process commands first
$commandHandler = new CommandHandler($bot);
if ($commandHandler->process()) {
    http_response_code(200);
    exit('Command processed');
}

// Then process notifications
$notificationHandler = new NotificationHandler($bot);
$notificationHandler->process();

http_response_code(200);
exit('OK');
